/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.script.ScriptParser;
import org.apache.tapestry.util.xml.DocumentParseException;

public class DefaultScriptSource
implements IScriptSource {
    private IResourceResolver _resolver;
    private Map _cache = new HashMap();

    public DefaultScriptSource(IResourceResolver resolver) {
        this._resolver = resolver;
    }

    public synchronized void reset() {
        this._cache.clear();
    }

    public synchronized IScript getScript(IResourceLocation scriptLocation) {
        IScript result = (IScript)this._cache.get(scriptLocation);
        if (result != null) {
            return result;
        }
        result = this.parse(scriptLocation);
        this._cache.put(scriptLocation, result);
        return result;
    }

    private IScript parse(IResourceLocation location) {
        ScriptParser parser = new ScriptParser(this._resolver);
        try {
            return parser.parse(location);
        }
        catch (DocumentParseException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("DefaultScriptSource.unable-to-parse-script", location), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer("DefaultScriptSource@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._cache != null) {
            Map map = this._cache;
            synchronized (map) {
                buffer.append(this._cache.keySet());
            }
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

