/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance.javassist;

import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.enhance.CodeGenerationException;
import org.apache.tapestry.enhance.EnhancedClassLoader;
import org.apache.tapestry.enhance.IEnhancedClass;
import org.apache.tapestry.enhance.IEnhancedClassFactory;
import org.apache.tapestry.enhance.javassist.ClassMapping;
import org.apache.tapestry.enhance.javassist.EnhancedClass;

public class EnhancedClassFactory
implements IEnhancedClassFactory {
    private IResourceResolver _resourceResolver;
    private EnhancedClassLoader _enhancedClassLoader;
    private ClassPool _classPool;
    private ClassMapping _typeMap = null;

    public EnhancedClassFactory(IResourceResolver resourceResolver) {
        this._resourceResolver = resourceResolver;
        this.reset();
    }

    protected ClassPool createClassPool() {
        ClassLoader loader = this._resourceResolver.getClassLoader();
        ClassPool classPool = new ClassPool(null);
        classPool.insertClassPath((ClassPath)new LoaderClassPath(loader));
        return classPool;
    }

    public synchronized void reset() {
        this._classPool = this.createClassPool();
        this._typeMap = new ClassMapping(this._classPool);
        ClassLoader loader = this._resourceResolver.getClassLoader();
        this._enhancedClassLoader = new EnhancedClassLoader(loader);
    }

    public IEnhancedClass createEnhancedClass(String className, Class parentClass) {
        return new EnhancedClass(className, parentClass, this);
    }

    public ClassPool getClassPool() {
        return this._classPool;
    }

    public ClassMapping getClassMapping() {
        return this._typeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtClass getObjectType(String type) {
        CtClass result = this.getClassMapping().getType(type);
        if (result == null) {
            EnhancedClassFactory enhancedClassFactory = this;
            synchronized (enhancedClassFactory) {
                result = this.getClassMapping().getType(type);
                if (result == null) {
                    try {
                        result = this._classPool.get(type);
                        this.getClassMapping().recordType(type, result);
                    }
                    catch (NotFoundException e) {
                        throw new CodeGenerationException(e);
                    }
                }
            }
        }
        return result;
    }

    public EnhancedClassLoader getEnhancedClassLoader() {
        return this._enhancedClassLoader;
    }
}

