/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.tapestry.AbstractMarkupWriter;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.html.NestedHTMLWriter;

public class HTMLWriter
extends AbstractMarkupWriter {
    private static final String[] entities = new String[64];
    private static final boolean[] safe = new boolean[128];
    private static final String SAFE_CHARACTERS = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\t\n\r !\"#$%'()*+,-./:;=?@[\\]^_`{|}~";

    public HTMLWriter(PrintWriter writer) {
        super(safe, entities, "text/html", writer);
    }

    public HTMLWriter(String contentType, OutputStream outputStream) {
        super(safe, entities, contentType, outputStream);
    }

    public HTMLWriter(String contentType, String encoding, OutputStream outputStream) {
        super(safe, entities, contentType, encoding, outputStream);
    }

    protected HTMLWriter(String contentType) {
        super(safe, entities, contentType);
    }

    public HTMLWriter(OutputStream outputStream) {
        this(outputStream, "UTF-8");
    }

    public HTMLWriter(OutputStream outputStream, String encoding) {
        this("text/html", encoding, outputStream);
    }

    public IMarkupWriter getNestedWriter() {
        return new NestedHTMLWriter(this);
    }

    static {
        HTMLWriter.entities[34] = "&quot;";
        HTMLWriter.entities[60] = "&lt;";
        HTMLWriter.entities[62] = "&gt;";
        HTMLWriter.entities[38] = "&amp;";
        int length = SAFE_CHARACTERS.length();
        for (int i = 0; i < length; ++i) {
            HTMLWriter.safe[SAFE_CHARACTERS.charAt((int)i)] = true;
        }
    }
}

