/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.prop;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.util.prop.PropertyInfo;

public class PropertyFinder {
    private static Map _cache = new HashMap();

    public static synchronized PropertyInfo getPropertyInfo(Class beanClass, String propertyName) {
        Map beanClassMap = (Map)_cache.get(beanClass);
        if (beanClassMap == null) {
            beanClassMap = PropertyFinder.buildBeanClassMap(beanClass);
            _cache.put(beanClass, beanClassMap);
        }
        return (PropertyInfo)beanClassMap.get(propertyName);
    }

    private static Map buildBeanClassMap(Class beanClass) {
        HashMap<String, PropertyInfo> result = new HashMap<String, PropertyInfo>();
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("PropertyFinder.unable-to-introspect-class", beanClass.getName()), ex);
        }
        PropertyDescriptor[] pd = bi.getPropertyDescriptors();
        for (int i = 0; i < pd.length; ++i) {
            PropertyDescriptor d = pd[i];
            PropertyInfo info = new PropertyInfo(d.getName(), d.getPropertyType(), d.getReadMethod() != null, d.getWriteMethod() != null);
            result.put(d.getName(), info);
        }
        return result;
    }
}

