/*
 * Decompiled with CFR 0.152.
 */
package com.boxity.components;

import java.io.IOException;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

public abstract class Include
extends AbstractComponent {
    private static final Log _log = LogFactory.getLog(Include.class);

    public abstract Object getUri();

    public abstract String getStyleClass();

    public abstract boolean getCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String styleClass;
        if (cycle.isRewinding()) {
            return;
        }
        Object uri = this.getUri();
        if (uri == null) {
            return;
        }
        String key = "boxity_include_" + uri;
        String responseBody = null;
        boolean shouldStore = false;
        if (this.getCache()) {
            try {
                responseBody = (String)cycle.getEngine().getPool().retrieve((Object)key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (responseBody == null) {
            if (this.getCache()) {
                shouldStore = true;
            }
            try {
                HttpClient client = new HttpClient();
                GetMethod method = new GetMethod(uri.toString());
                DefaultMethodRetryHandler retryhandler = new DefaultMethodRetryHandler();
                retryhandler.setRequestSentRetryEnabled(false);
                retryhandler.setRetryCount(3);
                method.setMethodRetryHandler((MethodRetryHandler)retryhandler);
                try {
                    int statusCode = client.executeMethod((HttpMethod)method);
                    if (statusCode != 200) {
                        _log.error((Object)("Method failed: " + method.getStatusLine()));
                    }
                    responseBody = method.getResponseBodyAsString();
                    _log.debug((Object)responseBody);
                }
                catch (IOException e) {
                    _log.error((Object)"Failed to get response.");
                    e.printStackTrace();
                }
                finally {
                    method.releaseConnection();
                }
            }
            catch (Exception e) {
                responseBody = null;
                _log.error((Object)e);
            }
        }
        if (responseBody == null) {
            return;
        }
        if (this.getCache() && shouldStore) {
            try {
                cycle.getEngine().getPool().store((Object)key, (Object)responseBody);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((styleClass = this.getStyleClass()) != null) {
            writer.begin("span");
            writer.attribute("class", styleClass);
            this.renderInformalParameters(writer, cycle);
        }
        writer.printRaw(responseBody);
        if (styleClass != null) {
            writer.end();
        }
    }
}

